*
* SpeechLab 20A ROM code
* (c) 1978, Heuristics
* (s) 2019, Brutal Deluxe Software
*
* Thank you, Jeremy Apple
*

         TYP   BIN
         ORG   $00C800
         MX    %11
         LST   OFF
 
*---------------------------------------------------------

*--- Equates

numWORDS	=	32	; number of words one can speech
wordSIZE	=	64	; buffer size for a spoken word

*--- Zero page equates

CSWL	=	$36		; for output
CSWH	=	CSWL+1
KSWL	=	CSWH+1		; for input
KSWH	=	KSWL+1

A5H	=	$56		; save A
XREG	=	A5H+1		; save X
YREG	=	XREG+1		; save Y
STATUS	=	YREG+1		; save P
SPNT	=	STATUS+1	; stack pointer

zpF0	=	$f0
zpF1	=	zpF0+1

*--- Buffers and friends

L0800	=	$0800		; area where some code is copied (see LCBDF)
L081F	=	L0800+$1F	; a value
L0820	=	L081F+1		; a table of $20 bytes (0: no word, 1: a word)
L0840	=	L0820+$20	; bytes in a large buffer
L0859	=	L0840+$19 	; read buffer
				; the buffer is $258 (600d) bytes long
L0AB1	=	L0859+600	; a buffer ($40 bytes)
L0AF1	=	L0AB1+$40	; a buffer ($800 bytes)
				; $20 words x $40 bytes per word = $800 bytes ;-)

L12F1	=	L0AF1+$800	; slot
L12F2	=	L12F1+1		; slot*16
L12F3	=	L12F2+1		; index in list of words, see L12F6
L12F4	=	L12F3+1		; Y as an index
L12F5	=	L12F4+1		; A as an index
L12F6	=	L12F5+1		; table of pointers low ($21 bytes)
L1317	=	L12F6+$21	; table of pointers high ($21 bytes)
L1339	=	L1317+$22	; a buffer of words (the words)

*--- Firmware/ROM equates

CLRROM	=	$CFFF

RANGERR	=	$EE68	; Display "*** RANGE ERR" (INT BASIC)

SAVE	=	$F669	; Save A/X/Y/P (unofficial label) ==> see the end of the code
RESTORE	=	$F67E	; Restore A/X/Y/P (unofficial label) ==> see the end of the code
BELL1	=	$FBDD	; Beep
COUT1	=	$FDF0	; Output a char
IORTS	=	$FEAD	; It is a RTS on early ROMs (unofficial label)

*---------------------------------------------------------
* The card runs with the INT ROM on
* If the "modern" ROMs are called,
* then calls to SAVE/RESTORE will be useless

         PHA
         PHP
         SEI
         BIT   CLRROM
         JSR   LC809

*--- CALLED BY $Cs00

LC809    PLA
         PLA
         STA   L12F1	; slot ($C5)
         ASL
         ASL
         ASL
         ASL
         STA   L12F2	; slot*16 ($50)
         PLP
         PLA

LC817    JSR   SAVE	; save all parms
         LDA   CSWH	; output is already set to our card?
         CMP   L12F1
         BEQ   LC878	; yes
	
         LDA   #<LC84B	; set input as well
         STA   KSWL
         LDA   #>LC84B
         STA   KSWH
         LDA   #<IORTS	; and output goes to RTS
         STA   CSWL
         LDA   #>IORTS
         STA   CSWH

         LDY   #$00	; string index is 0
         STY   L12F4
         JSR   LC956	; DO MAGIC
         CMP   #numWORDS
         BPL   LC875
         TAX		; index
         LDA   L12F6,X	; pointer
         STA   SPNT
         LDA   L1317,X
         STA   SPNT+1
         JSR   RESTORE	; restore

LC84B    JSR   SAVE	; save
         LDY   L12F4	; get index
         LDA   (SPNT),Y	; get char
         INC   L12F4	; y++
         CMP   #$8D	; end of string?
         BNE   LC864	; no

LC85A    LDA   #<LC817	; input to our card
         STA   KSWL
         LDA   #>LC817
         STA   KSWH
         LDA   #$8D	; exit with a RET
LC864    PHA		; save
         JSR   RESTORE	; restore
         PLA		; pull A
         RTS		; return

LC86A    LDA   #<COUT1	; reset cout
         STA   CSWL
         LDA   #>COUT1
         STA   CSWH
         JMP   RANGERR	; exit to RANGE ERR

LC875    JMP   LC85A

*--- Card is already init'ed

LC878    LDA   A5H	; get a char
         CMP   #$8D	; 8D means reset list of words
         BEQ   LC8D8

         LDA   #<LC89F	; cout
         STA   CSWL
         LDA   #>LC89F
         STA   CSWH

         LDY   #$00	; Y as a counter
         STY   L12F4
         LDX   L12F3	; word index
         CPX   #numWORDS
         BPL   LC86A	; we're full!
         LDA   L12F6,X	; get its pointer
         STA   SPNT
         LDA   L1317,X
         STA   SPNT+1
         JSR   RESTORE	; restore registers

LC89F    JSR   SAVE	; save registers
         LDA   A5H	; get A
         LDY   L12F4	; get Y
         STA   (SPNT),Y	; save char
         INC   L12F4	; y++
         CMP   #$8D
         BNE   LC8D4

         LDA   L12F3	; we're done, get word index
         JSR   LC909	; DO MAGIC
         INC   L12F3	; next index
         LDX   L12F3	; get it again
         LDA   SPNT	; ptr to char
         CLC
         ADC   L12F4	; +index in string
         STA   L12F6,X	; save pointer low
         LDA   SPNT+1
         ADC   #$00
         STA   L1317,X	; save pointer high

         LDA   #<LC817	; cout
         STA   CSWL
         LDA   #>LC817
         STA   CSWH
LC8D4    JSR   RESTORE	; restore and exit (JMP)
         RTS

LC8D8    LDA   #$00	; word index
         STA   L12F3
         LDA   #<L1339	; pointer to buffer
         STA   L12F6
         LDA   #>L1339
         STA   L1317
         LDA   #$00	; init table of words
         LDX   #numWORDS-1
LC8EB    STA   L0820,X
         DEX
         BPL   LC8EB
LC8F1    INX		; copy code
         LDA   LCBDF,X
         STA   L0800,X
         CPX   #$1F
         BMI   LC8F1
         JSR   RESTORE	; restore all and return (JMP)
         RTS

*---------------------------------------------------------
* Page $C900
* That page is the $Cs00..$CsFF page

         PHA
         PHP
         SEI
         BIT   CLRROM
         JSR   LC809

LC909    STA   L081F
         TAX
         LDA   #$01
         STA   L0820,X

*--- CALLED BY $Cs00

LC912    JSR   LC973
         BEQ   LC96D
         JSR   LCB2D
         LDA   #<L0AF1
         STA   L0808+1
         LDA   #>L0AF1
         STA   L0808+2
         LDA   #$00
         LSR   L081F
         BCC   LC92D
         LDA   #wordSIZE
LC92D    LSR   L081F
         BCC   LC934
         ORA   #$80
LC934    CLC
         ADC   L0808+1
         STA   L0808+1
         LDA   L0808+2
         ADC   L081F
         STA   L0808+2
         LDA   #<L0AB1
         STA   L0805+1
         LDA   #>L0AB1
         STA   L0805+2
         LDA   #wordSIZE-1
         JSR   L0804
         LDA   #$00
         RTS

LC956    JSR   LC973
         CMP   #$00
         BEQ   LC967
         JSR   LCB2D
         JSR   LCA94
         LDA   L0840
         RTS

LC967    JSR   BELL1
         JMP   LC956

LC96D    JSR   BELL1
         JMP   LC912

*--- CALLED BY $Cs00

LC973    LDA   #$00
         STA   L0840+$1
         STA   L0840+$2
LC97B    LDA   #<L0859	; start of buffer
         STA   L080F+1
         LDA   #>L0859
         STA   L080F+2
         JSR   LC9E9
         BEQ   LC97B
         LDA   #$08
         STA   L0840+$7
LC98F    JSR   LC9E9
         BEQ   LC973
         DEC   L0840+$7
         BNE   LC98F
         LDA   #$0A
         STA   L0840+$8
LC99E    JSR   LC9E9
         BEQ   LC9B9
         LDA   #$0A
         STA   L0840+$8
LC9A8    LDA   L080F+2	; end of buffer?
         CMP   #>L0AB1
         BNE   LC99E
         LDA   L080F+1
         CMP   #<L0AB1
         BNE   LC99E	; no
         LDA   #$00	; yes, exit
         RTS

LC9B9    DEC   L0840+$8
         BNE   LC9A8
         LDA   L080F+1
         SEC
         SBC   #$28
         STA   L080F+1
         LDA   L080F+2
         SBC   #$00
         STA   L080F+2
         LDA   L080F+1
         SEC
         SBC   #<L0859
         STA   L0840+$15
         LDA   L080F+2
         SBC   #>L0859
         ROR
         ROR   L0840+$15
         ROR
         ROR   L0840+$15
         LDA   L0840+$15
         RTS

LC9E9    LDY   #$00
         LDX   L12F2
         STY   L0840+$9
         LDA   $C080,X
         EOR   #$FF
         AND   #$01
         BEQ   LCA0B
         STA   L0840+$9
         JMP   LCA09

*---------------------------------------------------------
* Page $CA00

         PHA
         PHP
         SEI
         BIT   CLRROM
         JSR   LC809

LCA09    LDA   #$08
LCA0B    JSR   L080F
         LDA   $C080,X
         EOR   #$FF
         AND   #$10
         BEQ   LCA1A
         STA   L0840+$9
LCA1A    LDA   #$08
         JSR   L080F
         JSR   LCA26
         LDA   L0840+$9
         RTS

LCA26    LDA   #$C8		; counter
         STA   L0840+$A
         LDA   #$00
         STA   L0840+$4
         STA   L0840+$5
         LDA   L0840+$1
         STA   L0840+$B
         LDA   L0840+$2
         STA   L0840+$C
LCA3F    LDA   $C080,X
         AND   #$08
         CMP   L0840+$B
         BEQ   LCA52
         STA   L0840+$B
         INC   L0840+$4
LCA4F    JMP   LCA5B

LCA52    LDA   L0840+$4
         JMP   LCA58
LCA58    JMP   LCA4F

LCA5B    LDA   $C080,X
         AND   #$80
         CMP   L0840+$C
         BEQ   LCA6E
         STA   L0840+$C
         INC   L0840+$5
LCA6B    JMP   LCA77

LCA6E    LDA   L0840+$5
         JMP   LCA74
LCA74    JMP   LCA6B

LCA77    DEC   L0840+$A
         BNE   LCA3F
         LDA   L0840+$4
         CMP   #$20
         BCC   LCA86
         STA   L0840+$9
LCA86    JSR   L080F
         LDA   L0840+$5
         CMP   #$50
         BCC   LCA90
LCA90    JSR   L080F
         RTS

LCA94    LDA   #<L0AF1
         SEC
         SBC   #wordSIZE
         STA   L0800+1
         LDA   #>L0AF1
         SBC   #$00
         STA   L0800+2
         LDA   #$F4
         STA   L0840+$D
         LDA   #$01
         STA   L0840+$E
         LDA   #$20
         STA   L0840
         LDY   #$FF
LCAB4    INY
         CPY   #numWORDS
         BMI   LCABA
         RTS

LCABA    LDA   #wordSIZE	; next
         CLC
         ADC   L0800+1
         STA   L0800+1
         LDA   #$00
         ADC   L0800+2
         STA   L0800+2
         LDA   L0820,Y
         BEQ   LCAB4
         LDA   #$00
         STA   L0840+$F
         STA   L0840+$10
         LDX   #wordSIZE-1
LCADA    JSR   L0800
         SEC
         SBC   L0AB1,X
         BCS   LCAE7
         EOR   #$FF
         ADC   #$01
LCAE7    CLC
         ADC   L0840+$10
         STA   L0840+$10
         LDA   #$00
         ADC   L0840+$F
         STA   L0840+$F
         CMP   L0840+$D
         JMP   LCB09

         DB    $CF	; not used
         DB    $0C
         DB    $FE
         DB    $0D

*---------------------------------------------------------
* Page $CB00

         PHA
         PHP
         SEI
         BIT   CLRROM
         JSR   LC809

LCB09    BCC   LCB15
         BNE   LCAB4
         LDA   L0840+$10
         CMP   L0840+$E
         BCS   LCAB4
LCB15    DEX
         BMI   LCB1B
         JMP   LCADA

LCB1B    LDA   L0840+$F
         STA   L0840+$D
         LDA   L0840+$10
         STA   L0840+$E
         STY   L0840
         JMP   LCAB4

*--- CALLED BY $Cs00

LCB2D    LDA   #<L0AB1
         STA   L080F+1
         LDA   #>L0AB1
         STA   L080F+2
         LDA   L0840+$15
         STA   L0840+$13
         LDA   #$00
         STA   L0840+$11
         LDA   #$10
         STA   L0840+$12
         JSR   LCBA3
         STA   zpF0
         STA   zpF1
         LDA   L0840+$13
         ASL
         ASL
         STA   L0840+$16
         BEQ   LCB5B
         SEC
         SBC   #$04
LCB5B    CLC
         ADC   #<L0859
         STA   L081B+1
         LDA   #>L0859
         ADC   #$00
         STA   L081B+2
         LDA   #$10
         STA   L12F5
LCB6D    LDY   #$00
LCB6F    JSR   L081B
         JSR   L080F
         INY
         CPY   #$04
         BNE   LCB6F
         LDA   zpF0
         CLC
         ADC   zpF1
         STA   zpF0
         SEC
         SBC   #$10
         BMI   LCB8C
         STA   zpF0
         LDA   #$04
         BPL   LCB8E
LCB8C    LDA   #$00
LCB8E    CLC
         ADC   L0840+$16
         ADC   L081B+1
         STA   L081B+1
         BCC   LCB9D
         INC   L081B+2
LCB9D    DEC   L12F5
         BNE   LCB6D
         RTS

LCBA3    CLC
         LDX   #$F7
         LDA   L0840+$11
LCBA9    ROL   L0840+$13
         INX
         BMI   LCBB2
         JMP   LCBC7

LCBB2    ROL
         BCC   LCBBB
         SBC   L0840+$12
         SEC
         BCS   LCBA9
LCBBB    SEC
         SBC   L0840+$12
         BCS   LCBA9
         ADC   L0840+$12
         CLC
         BCC   LCBA9
LCBC7    STA   L0840+$11
         RTS

         CLC		; not called?
         LDA   L0840+$14
         ADC   L0840+$13
         STA   L0840+$13
         LDA   L0840+$12
         ADC   L0840+$11
         STA   L0840+$11
         RTS

LCBDF    =     *

*---------------------------------------------------------
* The code is copied at $0800

         ORG   $000800
         LDA   |$0000,X   ; CODE AT $0800
         RTS

L0804    TAX
L0805    LDA   |$0000,X
L0808    STA   |$0000,X
         DEX
         BPL   L0805
         RTS

L080F    STA   |$0000
         INC   L080F+1
         BNE   L081A
         INC   L080F+2
L081A    RTS

L081B    LDA   |$0000,Y
         RTS

         DB    $5A
         DB    $4D

*---------------------------------------------------------
* The manual says the ROM is 1K
* So... this is the end :-)
* Antoine

* SAVE as I call it:
* 00/F669: 84 58        STY 58            
* 00/F66B: 86 57        STX 57            
* 00/F66D: 85 56        STA 56            
* 00/F66F: 08           PHP               
* 00/F670: 68           PLA               
* 00/F671: 85 59        STA 59            
* 00/F673: BA           TSX               
* 00/F674: E8           INX               
* 00/F675: E8           INX               
* 00/F676: BD 00 01     LDA 0100,X        
* 00/F679: 0A           ASL               
* 00/F67A: 0A           ASL               
* 00/F67B: 0A           ASL               
* 00/F67C: 0A           ASL               
* 00/F67D: 60           RTS               

* RESTORE as I call it:
* 00/F67E: A4 58        LDY 58            
* 00/F680: A6 57        LDX 57            
* 00/F682: A5 59        LDA 59            
* 00/F684: 48           PHA               
* 00/F685: A5 56        LDA 56            
* 00/F687: 28           PLP               
* 00/F688: 60           RTS             